function Vadot = state_eq(t,Va);

global Vtotal Vwo Patm Pao Aa Ae rho;

if(Va <= Vtotal) % there's still some water in there
    
    % find the instantaneous air pressure using the equation from the
    % "Air Expansion" section on the wiki:
    Pa = Pao * (Va/(Vtotal-Vwo))^(-1.4);

    % now we need to find the rate of change in the air volume.  We can
    % use Bernoulli's equation to find va (the velocity of the air/water
    % boundary), then multiply this by the chamber area to get the change 
    % in volume.  But first, we need to remove the unknown ve (exit 
    % velocity) from the equation, which we can do by recognizing that 
    % ve = (Aa/Ae) * va.  Plugging this into the second equation under
    % "Water Nozzle Exit Velocity", we can isolate va:
    va = sqrt(2*(Pa - Patm)/(rho * ((Aa/Ae)^2 - 1)));

    % and now we can find the derivative of the air volume
    Vadot = Aa * va;

else % if we've run out of water, don't let it suck a vacuum

    Vadot = 0;
     
end